# number of timesteps to iterate the model
t_max = 10

# initial population size
N0 = 20

# population growth rate
r = 0.2

# initialise an empty vector to store the population sizes
# over time
Ns = numeric(t_max+1)
# set the population size in the first timestep to N0
Ns[1] = N0

# execute a loop from time t=1 to t=t_max, iterating the map
for ( t in 1:t_max )
  Ns[t+1] = (1+r)*Ns[t]

# plot the results
plot(0:t_max,Ns,pch=19,type='o',xlab='t',ylab='N',
     ylim=c(0,max(Ns)))

r = -0.2
for ( t in 1:t_max )
  Ns[t+1] = (1+r)*Ns[t]
points(0:t_max,Ns,pch=1,type='o') 

